local mods, actorCmds

return Def.ActorFrame {
	InitCommand = function(self)
	end,

	OnCommand = function(self)
		local screen = SCREENMAN:GetTopScreen()

		local null = self:GetChild('NullActorFrame')

		local p1 = screen:GetChild('PlayerP1')
		local p2 = screen:GetChild('PlayerP2') or null

		if not p1 then
			for i,v in pairs(screen:GetChild('')) do
				if tostring(v):find('Player') then
					p1 = v
					break
				end
			end
		end

		local players = {p1, p2}

		local p1state = GAMESTATE:GetPlayerState(PLAYER_1)
		local p2state = GAMESTATE:GetPlayerState(PLAYER_2)


		local zoomOut = '*24 200% mini'
		local zoomOutRestore = '*99 no mini'
		
		local Flivert = '*10 flip,*10 -100% invert'
		local FlivertOff = '*10 no flip,*10 no invert'

		mods = {
			{0, '*99 2.25x,*99 -1000% cover,*99 no mini,*99 no reverse,*99 overhead,*99 blind'},
			{1, '*99 -169% tiny'},
			{1.25, '*8 no tiny'},
			{9, '*99 -169% tiny'},
			{9.25, '*8 no tiny'},
			{9.5, '*99 -169% tiny'},
			{9.75, '*8 no tiny'},
			{10, '*99 -169% tiny'},
			{10.25, '*8 no tiny'},
			{15.5, '*4 -120% tiny'},
			{17, '*7 no tiny'},
			{21, '*99 -169% tiny'},
			{21.25, '*8 no tiny'},
			{23.5, '*99 -169% tiny'},
			{23.75, '*8 no tiny'},
			{24, '*99 -169% tiny'},
			{24.25, '*8 no tiny'},
			{24.5, '*99 -169% tiny'},
			{24.75, '*8 no tiny'},
			{25, '*99 -169% tiny'},
			{25.25, '*8 no tiny'},
			{27, '*99 -169% tiny'},
			{27.25, '*8 no tiny'},
			{29, '*0.5 50% reverse,*0.5 50% flip'},
			{31, '*2 no reverse,*2 no flip'},
			{32, zoomOut},
			{33, '*8 250% bumpy', zoomOutRestore},
			{57, '*99 no bumpy,*99 -1000% beat,*99 invert'},
			{57.25, '*1337 no beat'},
			{59, '*99 1000% beat,*99 no invert,*99 flip'},
			{59.25, '*1337 no beat'},
			{61, '*99 -1000% beat,*99 no flip'},
			{61.25, '*1337 no beat'},
			{63, '*4 hallway'},
			{64, '*4 distant'},
			{66, '*99 1.5x'},
			{72, '*99 overhead'},
			{73, '*10 flip'},
			{73.667, '*10 invert,*99 no flip'},
			{74.333, Flivert},
			{75, '*10 flip,*99 no invert'},
			{75.667, '*10 invert,*99 no flip'},
			{76.333, '*10 no invert'},
			{77, '*10 flip'},
			{77.75, Flivert},
			{78.5, '*10 invert,*99 no flip'},
			{79.25, '*10 flip,*99 no invert'},
			{80, Flivert},
			{80.5, '*10 invert,*99 no flip'},
			{81, '*99 no invert'},
			{88.75, '*99 200% mini'},
			{89, '*6 no mini'},
			{89.75, '*99 200% mini'},
			{90, '*6 no mini'},
			{90.75, '*99 200% mini'},
			{91, '*6 no mini'},
			{91.25, '*99 200% mini'},
			{91.5, '*6 no mini'},
			{91.75, '*99 200% mini'},
			{92, '*6 no mini'},
			{92.25, '*99 200% mini'},
			{92.5, '*6 no mini'},
			{92.75, '*99 200% mini'},
			{93, '*6 no mini'},
			{93.25, '*99 200% mini'},
			{93.5, '*6 no mini'},
			{93.75, '*99 200% mini'},
			{94, '*54 no mini'},
			{103, '*4 xmode'},
			{104, '*4 -100% xmode'},
			{105, '*99 no xmode'},
			{111, '*4 -100% xmode'},
			{112, '*4 xmode'},
			{113, '*99 no xmode'},
			{119, '*4 xmode'},
			{120, '*4 -100% xmode'},
			{121, '*99 no xmode'},
			{125, '*4 space'},
			{126, '*4 incoming'},
			{127, '*4 distant'},
			{129, '*99 1000% beat,*99 overhead,*99 dark,*99 50% mini,*99 50% stealth,*99 2000% dizzy,*99 wave,*99 c125,*1000 cover'},
			{129.25, '*1337 no beat'},
			{143, '*99 -1000% beat'},
			{143.25, '*1337 no beat'},
			{144, '*99 1000% beat'},
			{144.25, '*1337 no beat'},
			{145, '*99 -1000% beat'},
			{145.25, '*1337 no beat'},
			{153, '*99 1000% beat'},
			{153.25, '*1337 no beat'},
			{154.5, '*99 -1000% beat'},
			{154.75, '*1337 no beat'},
			{156, '*99 1000% beat'},
			{156.25, '*1337 no beat'},
			{157.5, '*99 -1000% beat'},
			{157.75, '*1337 no beat'},
			{159, '*99 1000% beat,*6 no mini'},
			{159.25, '*1337 no beat'},
			{161, '*0.3 no stealth,*0.3 no dark,*0.3 2.25x,*0.3 no wave,*0.3 -1000% cover'},
			{189, '*2 xmode'},
			{191, '*2 -100% xmode'},
			{193, '*1337 no dizzy,*99 no xmode,*99 250% bumpy,*99 1.5x'},
			{225, '*4 blink'},
			{254, '*5 no blink'},
			{257, '*0.5 350% distant'},
			{273, '*0.5 150% hallway'},
			{285, '*99 -169% tiny'},
			{285.25, '*8 no tiny'},
			{286, '*99 -169% tiny'},
			{286.25, '*8 no tiny'},
			{286.5, '*99 -169% tiny'},
			{286.75, '*8 no tiny'},
			{287.5, '*99 -169% tiny'},
			{287.75, '*8 no tiny'},
			{288, '*99 -169% tiny'},
			{288.25, '*8 no tiny'},
			{305, '*0.5 350% distant'},
			{321, '*99 overhead'},
			{329, '*99 -169% tiny'},
			{329.25, '*8 no tiny'},
			{335, '*4 xmode'},
			{336, '*4 no xmode'},
			{337, '*99 -169% tiny'},
			{337.25, '*8 no tiny'},
			{341, '*99 -169% tiny'},
			{341.25, '*8 no tiny'},
			{346, '*6 5% reverse'},
			{346.667, '*6 10% reverse'},
			{347.333, '*6 25% reverse'},
			{348, '*6 40% reverse'},
			{348.667, '*6 75% reverse'},
			{349.333, '*6 reverse'},
			{368, '*99 no reverse'},
			{383, '*99 500% drunk'},
			{385, '*99 no drunk'},
			{391, zoomOut},
			{393, zoomOutRestore},
			{407, zoomOut},
			{409, zoomOutRestore},
			{417, '*99 no bumpy'},
			{425, '*99 -169% tiny'},
			{425.25, '*8 no tiny'},
			{425.5, '*99 -169% tiny'},
			{425.75, '*8 no tiny'},
			{426, '*99 -169% tiny'},
			{426.25, '*8 no tiny'},
			{431.5, '*4 -120% tiny'},
			{433, '*7 no tiny'},
			{437, '*99 -169% tiny'},
			{437.25, '*8 no tiny'},
			{438, '*99 -169% tiny'},
			{438.25, '*8 no tiny'},
			{439.5, '*99 -169% tiny'},
			{439.75, '*8 no tiny'},
			{440, '*99 -169% tiny'},
			{440.25, '*8 no tiny'},
			{440.5, '*99 -169% tiny'},
			{440.75, '*8 no tiny'},
			{441, '*99 -169% tiny'},
			{441.25, '*8 no tiny'},
			{443, '*99 -169% tiny'},
			{443.25, '*8 no tiny'},
			{455, '*99 -420% tiny,*99 -420% mini'}
		}
		
for beat=45,46, 0.06 do
	table.insert(mods, {beat, '*99 flip,*99 75% stealth'})
	table.insert(mods, {beat + 0.25, '*99 no flip,*99 no stealth'})
end

for beat=46,47, 0.06 do
	table.insert(mods, {beat, '*99 invert,*99 75% stealth'})
	table.insert(mods, {beat + 0.25, '*99 no invert,*99 no stealth'})
end

for beat=95,97, 0.06 do
	table.insert(mods, {beat, '*99 -100% invert,*99 flip,*99 75% stealth'})
	table.insert(mods, {beat + 0.25, '*99 no invert,*99 no flip,*99 no stealth'})
end

for beat=121,124, 0.5 do
	table.insert(mods, {beat, '*30 flip'})
	table.insert(mods, {beat + 0.333, '*30 no flip'})
end

for beat=223,225, 0.06 do
	table.insert(mods, {beat, '*99 flip,*99 75% stealth'})
	table.insert(mods, {beat + 0.25, '*99 no flip,*99 no stealth'})
end

reverloop={{325,327},{333,334},{338,339},{343,344}}

for i,v in pairs(reverloop) do
    for beat=v[1],v[2] do
        table.insert(mods, {beat, '*8 reverse'})
        table.insert(mods, {beat + 0.5, '*8 no reverse'})
    end
end
		

		local bounceplyrs = function()
			p1:bounce():effectmagnitude(0, 0, 420):effectclock('beat'):effectperiod(0.5)
			p2:bounce():effectmagnitude(0, 0, 420):effectclock('beat'):effectperiod(0.5)
		end
		
		local vibrateP = function()
			p1:vibrate()
			p2:vibrate()
		end
		
		local vibrateS = function()
			screen:vibrate():effectmagnitude(69, 69, 69)
		end
		
		local bounceplyrsslow = function()
			p1:bounce():effectmagnitude(0, 0, 360):effectclock('beat'):effectperiod(1)
			p2:bounce():effectmagnitude(0, 0, 360):effectclock('beat'):effectperiod(1)
		end

		local stopEffect = function()
			p1:stopeffect()
			p2:stopeffect()
			screen:stopeffect()
		end

		local Centerplyrs = function()
			for i=1, #players do
				players[i]
					:x(SCREEN_CENTER_X)
			end
		end

		local resetPlyrs = function()
			for i=1, #players do
				players[i]
					:rotationx(0)
					:rotationy(0)
					:rotationz(0)
					:zoom(1)
					:zoomz(1)
					:zoomy(1)
			end
		end
		
		local yeah = function()
			for i=1, #players do
				players[i]
					:smooth(0.1)
					:rotationz(50)
			end
		end
		
		local yeah2 = function()
			for i=1, #players do
				players[i]
					:smooth(0.1)
					:rotationz(-50)
			end
		end

		local zumzPlyrs = function()
			for i=1, #players do
				players[i]
					:smooth(2)
					:zoomz(1337)
			end
		end

		actorCmds = {
			{0.1, Centerplyrs},
			{15.5, zumzPlyrs},
			{17, resetPlyrs},
			{33, bounceplyrs},
			{57, stopEffect},
			{66, bounceplyrs},
			{72, stopEffect},
			{72.1, resetPlyrs},
			{81, bounceplyrs},
			{89, resetPlyrs},
			{89.1, stopEffect},
			{97, bounceplyrs},
			{103, resetPlyrs},
			{103.1, stopEffect},
			{105, bounceplyrs},
			{111, stopEffect},
			{111.1, resetPlyrs},
			{113, bounceplyrs},
			{119, resetPlyrs},
			{119.1, stopEffect},
			{193, bounceplyrsslow},
			{254, stopEffect},
			{257, bounceplyrsslow},
			{285, stopEffect},
			{289, bounceplyrsslow},
			{318, stopEffect},
			{353, bounceplyrs},
			{367, resetPlyrs},
			{367.1, stopEffect},
			{369, bounceplyrs},
			{383, resetPlyrs},
			{383.1, stopEffect},
			{385, bounceplyrs},
			{391, stopEffect},
			{391.1, resetPlyrs},
			{393, bounceplyrs},
			{407, resetPlyrs},
			{407.1, stopEffect},
			{409, bounceplyrs},
			{417, resetPlyrs},
			{417.1, stopEffect},
			{431.5, zumzPlyrs},
			{433, resetPlyrs},
			{445, vibrateP},
			{449, vibrateS},
			{455, stopEffect}
		}
		
waggu={{66,71},{81,88},{97,102},{105,110},{113,118},{353,366},{369,382},{385,390},{393,406},{409,416}}
		
for i,v in pairs(waggu) do
    for beat=v[1],v[2] do
        table.insert(actorCmds, {beat, yeah})
        table.insert(actorCmds, {beat + 0.5, yeah2})
    end
end

		-- for edit mode
		-- for i=#mods, 1, -1 do
		-- 	if GAMESTATE:GetSongBeat() > mods[i][1] then
		-- 		table.remove(mods, i)
		-- 	end
		-- end

		for i=#actorCmds, 1, -1 do
			if GAMESTATE:GetSongBeat() > actorCmds[i][1] then
				table.remove(actorCmds, i)
			end
		end

		p1:stopeffect()
		p2:stopeffect()

		local firstRun = true
		self:SetUpdateFunction(function(self, delta)
			local currentBeat = GAMESTATE:GetSongBeat()

			for i=1, #mods do
				local mod = mods[i]
				if not mod.done and currentBeat >= mod[1] then
					local modstr = table.concat({ unpack(mod, 2) }, ',')
					p1state:SetPlayerOptions('ModsLevel_Song', p1state:GetPlayerOptionsString('ModsLevel_Song')..','..modstr)
					p2state:SetPlayerOptions('ModsLevel_Song', p2state:GetPlayerOptionsString('ModsLevel_Song')..','..modstr)
					mod.done = true

					-- this is horrible, like, no
					-- only keeping for historical purposes
					-- for modname, values in pairs(mod) do
					-- 	if p1options[modname] then
					-- 		p1options[modname](p1options, unpack(values))
					-- 		p2options[modname](p2options, unpack(values))
					-- 	end
					-- end

					if not firstRun then
						break
					end
				end
			end

			for i=1, #actorCmds do
				local command = actorCmds[i]
				if not command.done and currentBeat > command[1] then
					command[2]()
					command.done = true
				end
			end
			
			for i=1,2 do
				SCREENMAN:GetTopScreen():GetChild('LifeP'..i):visible(false);
                SCREENMAN:GetTopScreen():GetChild('ScoreP'..i):visible(false);
				SCREENMAN:GetTopScreen():GetChild('Overlay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('Underlay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('BPMDisplay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('StageDisplay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('SongTitle'):visible(false);
				SCREENMAN:GetTopScreen():GetChild("SongMeterDisplay" .. PlayerNumberToString(i-1)):visible(false);
				SCREENMAN:GetTopScreen():GetChild("StepsDisplay" .. PlayerNumberToString(i-1)):visible(false);
			end

			if firstRun then
				p1:finishtweening()
				p2:finishtweening()
			end
			firstRun = false
		end)
	end,

	Def.Quad{ OnCommand = function(self) self:sleep(1000) end },
	Def.ActorFrame{ Name='NullActorFrame' },
	
	Def.ActorProxy {
		Name = "JudgeProxy",
		Condition="GAMESTATE:IsPlayerEnabled(PLAYER_1)",
		BeginCommand = function(self)
		if GAMESTATE:IsPlayerEnabled(PLAYER_1) then
			local Judge1 = SCREENMAN:GetTopScreen():GetChild('PlayerP1'):GetChild('Judgment');
			if Judge1 then 
				self:SetTarget(SCREENMAN:GetTopScreen():GetChild('PlayerP1'):GetChild('Judgment')); 
				Judge1:visible(true);
			else 
				self:hibernate(1);
			end
		end
		end,
		OnCommand = function(self)
		if GAMESTATE:IsPlayerEnabled(PLAYER_1) and GAMESTATE:IsPlayerEnabled(PLAYER_2) then
			self:x(SCREEN_WIDTH*0.25)
			self:y(SCREEN_CENTER_Y)
			self:zoom(0.8);
		else
			self:zoom(0.8)
			self:x(SCREEN_CENTER_X)
			self:y(SCREEN_CENTER_Y)
		end
		end,
	};
	Def.ActorProxy {
		Name = "JudgeProxy",
		Condition="GAMESTATE:IsPlayerEnabled(PLAYER_2)",
		BeginCommand = function(self)
		if GAMESTATE:IsPlayerEnabled(PLAYER_2) then
			local Judge1 = SCREENMAN:GetTopScreen():GetChild('PlayerP2'):GetChild('Judgment');
			if Judge1 then 
				self:SetTarget(SCREENMAN:GetTopScreen():GetChild('PlayerP2'):GetChild('Judgment')); 
				Judge1:visible(true);
			else 
				self:hibernate(1);
			end
		end
		end,
		OnCommand = function(self)
		if GAMESTATE:IsPlayerEnabled(PLAYER_1) and GAMESTATE:IsPlayerEnabled(PLAYER_2) then
			self:x(SCREEN_WIDTH*0.75)
			self:y(SCREEN_CENTER_Y)
			self:zoom(0.8);
		else
			self:zoom(0.8)
			self:x(SCREEN_CENTER_X)
			self:y(SCREEN_CENTER_Y)
		end
		end,
	};
}
